using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.ComponentModel.Design;


namespace Borland.Data.Web.Eco
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class EcoHandleCollectionDlg : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		public System.Windows.Forms.ListBox HandlesAddedCB;
		public System.Windows.Forms.ListBox HandlesToAddCB;
		private System.Windows.Forms.Button RemoveButton;
		private System.Windows.Forms.Button AddButton;
		private System.Windows.Forms.Button OK;
		private System.Windows.Forms.Button Cancel;
		private System.Windows.Forms.Button Help;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private IServiceProvider serviceProvider;
		private int currentHelpContext = 0;
		private const string SHelpKeywordPrefix = "bds2:";


		public EcoHandleCollectionDlg()
		{
			//
			// Required for Windows Form Designer support
			//
			currentHelpContext = 13422;
			InitializeComponent();
		}

		public EcoHandleCollectionDlg(IServiceProvider ServiceProvider)
		{
			serviceProvider = ServiceProvider;
			currentHelpContext = 13422;
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(EcoHandleCollectionDlg));
			this.HandlesAddedCB = new System.Windows.Forms.ListBox();
			this.HandlesToAddCB = new System.Windows.Forms.ListBox();
			this.RemoveButton = new System.Windows.Forms.Button();
			this.AddButton = new System.Windows.Forms.Button();
			this.OK = new System.Windows.Forms.Button();
			this.Cancel = new System.Windows.Forms.Button();
			this.Help = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// HandlesAddedCB
			// 
			this.HandlesAddedCB.AccessibleDescription = resources.GetString("HandlesAddedCB.AccessibleDescription");
			this.HandlesAddedCB.AccessibleName = resources.GetString("HandlesAddedCB.AccessibleName");
			this.HandlesAddedCB.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("HandlesAddedCB.Anchor")));
			this.HandlesAddedCB.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("HandlesAddedCB.BackgroundImage")));
			this.HandlesAddedCB.ColumnWidth = ((int)(resources.GetObject("HandlesAddedCB.ColumnWidth")));
			this.HandlesAddedCB.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("HandlesAddedCB.Dock")));
			this.HandlesAddedCB.Enabled = ((bool)(resources.GetObject("HandlesAddedCB.Enabled")));
			this.HandlesAddedCB.Font = ((System.Drawing.Font)(resources.GetObject("HandlesAddedCB.Font")));
			this.HandlesAddedCB.HorizontalExtent = ((int)(resources.GetObject("HandlesAddedCB.HorizontalExtent")));
			this.HandlesAddedCB.HorizontalScrollbar = ((bool)(resources.GetObject("HandlesAddedCB.HorizontalScrollbar")));
			this.HandlesAddedCB.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("HandlesAddedCB.ImeMode")));
			this.HandlesAddedCB.IntegralHeight = ((bool)(resources.GetObject("HandlesAddedCB.IntegralHeight")));
			this.HandlesAddedCB.ItemHeight = ((int)(resources.GetObject("HandlesAddedCB.ItemHeight")));
			this.HandlesAddedCB.Location = ((System.Drawing.Point)(resources.GetObject("HandlesAddedCB.Location")));
			this.HandlesAddedCB.Name = "HandlesAddedCB";
			this.HandlesAddedCB.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("HandlesAddedCB.RightToLeft")));
			this.HandlesAddedCB.ScrollAlwaysVisible = ((bool)(resources.GetObject("HandlesAddedCB.ScrollAlwaysVisible")));
			this.HandlesAddedCB.Size = ((System.Drawing.Size)(resources.GetObject("HandlesAddedCB.Size")));
			this.HandlesAddedCB.TabIndex = ((int)(resources.GetObject("HandlesAddedCB.TabIndex")));
			this.HandlesAddedCB.Visible = ((bool)(resources.GetObject("HandlesAddedCB.Visible")));
			this.HandlesAddedCB.KeyDown += new System.Windows.Forms.KeyEventHandler(this.EcoHandleCollectionDlg_KeyDown);
			this.HandlesAddedCB.DoubleClick += new System.EventHandler(this.HandlesAddedCB_DoubleClick);
			this.HandlesAddedCB.KeyUp += new System.Windows.Forms.KeyEventHandler(this.HandlesAddedCB_KeyUp);
			this.HandlesAddedCB.MouseUp += new System.Windows.Forms.MouseEventHandler(this.HandlesAddedCB_MouseUp);
			// 
			// HandlesToAddCB
			// 
			this.HandlesToAddCB.AccessibleDescription = resources.GetString("HandlesToAddCB.AccessibleDescription");
			this.HandlesToAddCB.AccessibleName = resources.GetString("HandlesToAddCB.AccessibleName");
			this.HandlesToAddCB.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("HandlesToAddCB.Anchor")));
			this.HandlesToAddCB.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("HandlesToAddCB.BackgroundImage")));
			this.HandlesToAddCB.ColumnWidth = ((int)(resources.GetObject("HandlesToAddCB.ColumnWidth")));
			this.HandlesToAddCB.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("HandlesToAddCB.Dock")));
			this.HandlesToAddCB.Enabled = ((bool)(resources.GetObject("HandlesToAddCB.Enabled")));
			this.HandlesToAddCB.Font = ((System.Drawing.Font)(resources.GetObject("HandlesToAddCB.Font")));
			this.HandlesToAddCB.HorizontalExtent = ((int)(resources.GetObject("HandlesToAddCB.HorizontalExtent")));
			this.HandlesToAddCB.HorizontalScrollbar = ((bool)(resources.GetObject("HandlesToAddCB.HorizontalScrollbar")));
			this.HandlesToAddCB.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("HandlesToAddCB.ImeMode")));
			this.HandlesToAddCB.IntegralHeight = ((bool)(resources.GetObject("HandlesToAddCB.IntegralHeight")));
			this.HandlesToAddCB.ItemHeight = ((int)(resources.GetObject("HandlesToAddCB.ItemHeight")));
			this.HandlesToAddCB.Location = ((System.Drawing.Point)(resources.GetObject("HandlesToAddCB.Location")));
			this.HandlesToAddCB.Name = "HandlesToAddCB";
			this.HandlesToAddCB.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("HandlesToAddCB.RightToLeft")));
			this.HandlesToAddCB.ScrollAlwaysVisible = ((bool)(resources.GetObject("HandlesToAddCB.ScrollAlwaysVisible")));
			this.HandlesToAddCB.Size = ((System.Drawing.Size)(resources.GetObject("HandlesToAddCB.Size")));
			this.HandlesToAddCB.TabIndex = ((int)(resources.GetObject("HandlesToAddCB.TabIndex")));
			this.HandlesToAddCB.Visible = ((bool)(resources.GetObject("HandlesToAddCB.Visible")));
			this.HandlesToAddCB.KeyDown += new System.Windows.Forms.KeyEventHandler(this.EcoHandleCollectionDlg_KeyDown);
			this.HandlesToAddCB.DoubleClick += new System.EventHandler(this.HandlesToAddCB_DoubleClick);
			this.HandlesToAddCB.KeyUp += new System.Windows.Forms.KeyEventHandler(this.HandlesToAddCB_KeyUp);
			this.HandlesToAddCB.MouseUp += new System.Windows.Forms.MouseEventHandler(this.HandlesToAddCB_MouseUp);
			// 
			// RemoveButton
			// 
			this.RemoveButton.AccessibleDescription = resources.GetString("RemoveButton.AccessibleDescription");
			this.RemoveButton.AccessibleName = resources.GetString("RemoveButton.AccessibleName");
			this.RemoveButton.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("RemoveButton.Anchor")));
			this.RemoveButton.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("RemoveButton.BackgroundImage")));
			this.RemoveButton.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("RemoveButton.Dock")));
			this.RemoveButton.Enabled = ((bool)(resources.GetObject("RemoveButton.Enabled")));
			this.RemoveButton.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("RemoveButton.FlatStyle")));
			this.RemoveButton.Font = ((System.Drawing.Font)(resources.GetObject("RemoveButton.Font")));
			this.RemoveButton.Image = ((System.Drawing.Image)(resources.GetObject("RemoveButton.Image")));
			this.RemoveButton.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("RemoveButton.ImageAlign")));
			this.RemoveButton.ImageIndex = ((int)(resources.GetObject("RemoveButton.ImageIndex")));
			this.RemoveButton.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("RemoveButton.ImeMode")));
			this.RemoveButton.Location = ((System.Drawing.Point)(resources.GetObject("RemoveButton.Location")));
			this.RemoveButton.Name = "RemoveButton";
			this.RemoveButton.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("RemoveButton.RightToLeft")));
			this.RemoveButton.Size = ((System.Drawing.Size)(resources.GetObject("RemoveButton.Size")));
			this.RemoveButton.TabIndex = ((int)(resources.GetObject("RemoveButton.TabIndex")));
			this.RemoveButton.Text = resources.GetString("RemoveButton.Text");
			this.RemoveButton.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("RemoveButton.TextAlign")));
			this.RemoveButton.Visible = ((bool)(resources.GetObject("RemoveButton.Visible")));
			this.RemoveButton.Click += new System.EventHandler(this.RemoveButton_Click);
			// 
			// AddButton
			// 
			this.AddButton.AccessibleDescription = resources.GetString("AddButton.AccessibleDescription");
			this.AddButton.AccessibleName = resources.GetString("AddButton.AccessibleName");
			this.AddButton.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("AddButton.Anchor")));
			this.AddButton.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("AddButton.BackgroundImage")));
			this.AddButton.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("AddButton.Dock")));
			this.AddButton.Enabled = ((bool)(resources.GetObject("AddButton.Enabled")));
			this.AddButton.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("AddButton.FlatStyle")));
			this.AddButton.Font = ((System.Drawing.Font)(resources.GetObject("AddButton.Font")));
			this.AddButton.Image = ((System.Drawing.Image)(resources.GetObject("AddButton.Image")));
			this.AddButton.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("AddButton.ImageAlign")));
			this.AddButton.ImageIndex = ((int)(resources.GetObject("AddButton.ImageIndex")));
			this.AddButton.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("AddButton.ImeMode")));
			this.AddButton.Location = ((System.Drawing.Point)(resources.GetObject("AddButton.Location")));
			this.AddButton.Name = "AddButton";
			this.AddButton.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("AddButton.RightToLeft")));
			this.AddButton.Size = ((System.Drawing.Size)(resources.GetObject("AddButton.Size")));
			this.AddButton.TabIndex = ((int)(resources.GetObject("AddButton.TabIndex")));
			this.AddButton.Text = resources.GetString("AddButton.Text");
			this.AddButton.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("AddButton.TextAlign")));
			this.AddButton.Visible = ((bool)(resources.GetObject("AddButton.Visible")));
			this.AddButton.Click += new System.EventHandler(this.AddButton_Click);
			// 
			// OK
			// 
			this.OK.AccessibleDescription = resources.GetString("OK.AccessibleDescription");
			this.OK.AccessibleName = resources.GetString("OK.AccessibleName");
			this.OK.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("OK.Anchor")));
			this.OK.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("OK.BackgroundImage")));
			this.OK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.OK.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("OK.Dock")));
			this.OK.Enabled = ((bool)(resources.GetObject("OK.Enabled")));
			this.OK.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("OK.FlatStyle")));
			this.OK.Font = ((System.Drawing.Font)(resources.GetObject("OK.Font")));
			this.OK.Image = ((System.Drawing.Image)(resources.GetObject("OK.Image")));
			this.OK.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("OK.ImageAlign")));
			this.OK.ImageIndex = ((int)(resources.GetObject("OK.ImageIndex")));
			this.OK.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("OK.ImeMode")));
			this.OK.Location = ((System.Drawing.Point)(resources.GetObject("OK.Location")));
			this.OK.Name = "OK";
			this.OK.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("OK.RightToLeft")));
			this.OK.Size = ((System.Drawing.Size)(resources.GetObject("OK.Size")));
			this.OK.TabIndex = ((int)(resources.GetObject("OK.TabIndex")));
			this.OK.Text = resources.GetString("OK.Text");
			this.OK.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("OK.TextAlign")));
			this.OK.Visible = ((bool)(resources.GetObject("OK.Visible")));
			this.OK.KeyDown += new System.Windows.Forms.KeyEventHandler(this.EcoHandleCollectionDlg_KeyDown);
			// 
			// Cancel
			// 
			this.Cancel.AccessibleDescription = resources.GetString("Cancel.AccessibleDescription");
			this.Cancel.AccessibleName = resources.GetString("Cancel.AccessibleName");
			this.Cancel.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("Cancel.Anchor")));
			this.Cancel.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("Cancel.BackgroundImage")));
			this.Cancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Cancel.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("Cancel.Dock")));
			this.Cancel.Enabled = ((bool)(resources.GetObject("Cancel.Enabled")));
			this.Cancel.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("Cancel.FlatStyle")));
			this.Cancel.Font = ((System.Drawing.Font)(resources.GetObject("Cancel.Font")));
			this.Cancel.Image = ((System.Drawing.Image)(resources.GetObject("Cancel.Image")));
			this.Cancel.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Cancel.ImageAlign")));
			this.Cancel.ImageIndex = ((int)(resources.GetObject("Cancel.ImageIndex")));
			this.Cancel.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("Cancel.ImeMode")));
			this.Cancel.Location = ((System.Drawing.Point)(resources.GetObject("Cancel.Location")));
			this.Cancel.Name = "Cancel";
			this.Cancel.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("Cancel.RightToLeft")));
			this.Cancel.Size = ((System.Drawing.Size)(resources.GetObject("Cancel.Size")));
			this.Cancel.TabIndex = ((int)(resources.GetObject("Cancel.TabIndex")));
			this.Cancel.Text = resources.GetString("Cancel.Text");
			this.Cancel.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Cancel.TextAlign")));
			this.Cancel.Visible = ((bool)(resources.GetObject("Cancel.Visible")));
			this.Cancel.KeyDown += new System.Windows.Forms.KeyEventHandler(this.EcoHandleCollectionDlg_KeyDown);
			// 
			// Help
			// 
			this.Help.AccessibleDescription = resources.GetString("Help.AccessibleDescription");
			this.Help.AccessibleName = resources.GetString("Help.AccessibleName");
			this.Help.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("Help.Anchor")));
			this.Help.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("Help.BackgroundImage")));
			this.Help.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("Help.Dock")));
			this.Help.Enabled = ((bool)(resources.GetObject("Help.Enabled")));
			this.Help.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("Help.FlatStyle")));
			this.Help.Font = ((System.Drawing.Font)(resources.GetObject("Help.Font")));
			this.Help.Image = ((System.Drawing.Image)(resources.GetObject("Help.Image")));
			this.Help.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Help.ImageAlign")));
			this.Help.ImageIndex = ((int)(resources.GetObject("Help.ImageIndex")));
			this.Help.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("Help.ImeMode")));
			this.Help.Location = ((System.Drawing.Point)(resources.GetObject("Help.Location")));
			this.Help.Name = "Help";
			this.Help.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("Help.RightToLeft")));
			this.Help.Size = ((System.Drawing.Size)(resources.GetObject("Help.Size")));
			this.Help.TabIndex = ((int)(resources.GetObject("Help.TabIndex")));
			this.Help.Text = resources.GetString("Help.Text");
			this.Help.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("Help.TextAlign")));
			this.Help.Visible = ((bool)(resources.GetObject("Help.Visible")));
			this.Help.Click += new System.EventHandler(this.Help_Click);
			this.Help.KeyDown += new System.Windows.Forms.KeyEventHandler(this.EcoHandleCollectionDlg_KeyDown);
			// 
			// label1
			// 
			this.label1.AccessibleDescription = resources.GetString("label1.AccessibleDescription");
			this.label1.AccessibleName = resources.GetString("label1.AccessibleName");
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("label1.Anchor")));
			this.label1.AutoSize = ((bool)(resources.GetObject("label1.AutoSize")));
			this.label1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("label1.Dock")));
			this.label1.Enabled = ((bool)(resources.GetObject("label1.Enabled")));
			this.label1.Font = ((System.Drawing.Font)(resources.GetObject("label1.Font")));
			this.label1.Image = ((System.Drawing.Image)(resources.GetObject("label1.Image")));
			this.label1.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label1.ImageAlign")));
			this.label1.ImageIndex = ((int)(resources.GetObject("label1.ImageIndex")));
			this.label1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("label1.ImeMode")));
			this.label1.Location = ((System.Drawing.Point)(resources.GetObject("label1.Location")));
			this.label1.Name = "label1";
			this.label1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("label1.RightToLeft")));
			this.label1.Size = ((System.Drawing.Size)(resources.GetObject("label1.Size")));
			this.label1.TabIndex = ((int)(resources.GetObject("label1.TabIndex")));
			this.label1.Text = resources.GetString("label1.Text");
			this.label1.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label1.TextAlign")));
			this.label1.Visible = ((bool)(resources.GetObject("label1.Visible")));
			// 
			// label2
			// 
			this.label2.AccessibleDescription = resources.GetString("label2.AccessibleDescription");
			this.label2.AccessibleName = resources.GetString("label2.AccessibleName");
			this.label2.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("label2.Anchor")));
			this.label2.AutoSize = ((bool)(resources.GetObject("label2.AutoSize")));
			this.label2.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("label2.Dock")));
			this.label2.Enabled = ((bool)(resources.GetObject("label2.Enabled")));
			this.label2.Font = ((System.Drawing.Font)(resources.GetObject("label2.Font")));
			this.label2.Image = ((System.Drawing.Image)(resources.GetObject("label2.Image")));
			this.label2.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label2.ImageAlign")));
			this.label2.ImageIndex = ((int)(resources.GetObject("label2.ImageIndex")));
			this.label2.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("label2.ImeMode")));
			this.label2.Location = ((System.Drawing.Point)(resources.GetObject("label2.Location")));
			this.label2.Name = "label2";
			this.label2.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("label2.RightToLeft")));
			this.label2.Size = ((System.Drawing.Size)(resources.GetObject("label2.Size")));
			this.label2.TabIndex = ((int)(resources.GetObject("label2.TabIndex")));
			this.label2.Text = resources.GetString("label2.Text");
			this.label2.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label2.TextAlign")));
			this.label2.Visible = ((bool)(resources.GetObject("label2.Visible")));
			// 
			// EcoHandleCollectionDlg
			// 
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.label2);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.Help);
			this.Controls.Add(this.Cancel);
			this.Controls.Add(this.OK);
			this.Controls.Add(this.AddButton);
			this.Controls.Add(this.RemoveButton);
			this.Controls.Add(this.HandlesToAddCB);
			this.Controls.Add(this.HandlesAddedCB);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximizeBox = false;
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimizeBox = false;
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "EcoHandleCollectionDlg";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.EcoHandleCollectionDlg_KeyDown);
			this.Load += new System.EventHandler(this.EcoHandleCollectionDlg_Load);
			this.Activated += new System.EventHandler(this.WinForm_Activated);
			this.ChangeUICues += new System.Windows.Forms.UICuesEventHandler(this.WinForm_ChangeUICues);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new EcoHandleCollectionDlg());
		}


		private void CheckButtonsEnabled()
		{
			RemoveButton.Enabled = HandlesAddedCB.SelectedItem != null;
			AddButton.Enabled = HandlesToAddCB.SelectedItem != null;
		}
		
		private void WinForm_ChangeUICues(object sender, System.Windows.Forms.UICuesEventArgs e)
		{
			CheckButtonsEnabled();
		}

		private void WinForm_Activated(object sender, System.EventArgs e)
		{
/*			if( HandlesToAddCB.Items.Count > 0 )
				HandlesToAddCB.SetSelected(0, true);
			if( HandlesAddedCB.Items.Count > 0 )
				HandlesAddedCB.SetSelected(0, true);
			CheckButtonsEnabled(); */
		}

		private void HandlesAddedCB_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			CheckButtonsEnabled();
		}

		private void HandlesToAddCB_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			CheckButtonsEnabled();
		}

		private void HandlesToAddCB_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			CheckButtonsEnabled();
		}

		private void HandlesAddedCB_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			CheckButtonsEnabled();
		}
		
		private void EcoHandleCollectionDlg_Load(object sender, System.EventArgs e)
		{
			if( HandlesToAddCB.Items.Count > 0 )
				HandlesToAddCB.SetSelected(0, true);
			if( HandlesAddedCB.Items.Count > 0 )
				HandlesAddedCB.SetSelected(0, true);
			CheckButtonsEnabled();
		}

		private void AddButton_Click(object sender, System.EventArgs e)
		{
			int SelItem = HandlesToAddCB.SelectedIndex;
			if( SelItem >= 0 )
			{
				HandlesAddedCB.Items.Add(HandlesToAddCB.Items[SelItem]);
				HandlesToAddCB.Items.Remove(HandlesToAddCB.Items[SelItem]);
				HandlesAddedCB.SetSelected(HandlesAddedCB.Items.Count -1, true);
			}
			CheckButtonsEnabled();
		}

		private void RemoveButton_Click(object sender, System.EventArgs e)
		{
			int SelItem = HandlesAddedCB.SelectedIndex;
			if( SelItem >= 0 )
			{
				HandlesToAddCB.Items.Add(HandlesAddedCB.Items[SelItem]);
				HandlesAddedCB.Items.Remove(HandlesAddedCB.Items[SelItem]);
				HandlesToAddCB.SetSelected(HandlesToAddCB.Items.Count -1, true);
			}
			CheckButtonsEnabled();
		}
		
		private void HandlesAddedCB_DoubleClick(object sender, System.EventArgs e)
		{
			RemoveButton_Click(sender, e);
		}

		public static void ShowKeywordHelp(IServiceProvider serviceProvider, string keyword)
		{
			IHelpService helpService = (IHelpService)serviceProvider.GetService(typeof(IHelpService));
			if (helpService != null)
				helpService.ShowHelpFromKeyword(keyword);
		}

		private void HandlesToAddCB_DoubleClick(object sender, System.EventArgs e)
		{
			AddButton_Click(sender, e);
		}

		// TODO: move this to DBWeb's ClassUtils
		protected void ShowHelp()
		{
			if (currentHelpContext != 0)
				EcoHandleCollectionDlg.ShowKeywordHelp(serviceProvider, SHelpKeywordPrefix+currentHelpContext.ToString());
		}

		private void EcoHandleCollectionDlg_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
		  if( e.KeyCode == Keys.H && e.Modifiers == Keys.Alt )
		  {
				HandlesToAddCB.SelectedIndex = -1;
				if( HandlesAddedCB.CanFocus )
					HandlesAddedCB.Focus();
				int SelItem = HandlesAddedCB.SelectedIndex;
				if( SelItem < 0 && HandlesAddedCB.Items.Count > 0 )
					HandlesAddedCB.SelectedIndex = 0;
		  }
		  else if( e.KeyCode == Keys.A && e.Modifiers == Keys.Alt )
		  {
				HandlesAddedCB.SelectedIndex = -1;
				if( HandlesToAddCB.CanFocus )
					HandlesToAddCB.Focus();
				int SelItem = HandlesToAddCB.SelectedIndex;
				if( SelItem < 0 && HandlesToAddCB.Items.Count > 0 )
					HandlesToAddCB.SelectedIndex = 0;
		  }
		}
		
		private void Help_Click(object sender, System.EventArgs e)
		{
			ShowHelp();
		}

	}
}
